#!/bin/sh

rm -rf "$(dirname "$0")"/flash-scripts

for g in $(find "$(dirname "$0")"/keymaps/ -type d -maxdepth 1 -mindepth 1 -exec basename "{}" ";"); do
	model="$(echo $g | sed -E 's/(_r|_l)$//g')"
	mkdir -p "$(dirname "$0")"/flash-scripts/"$model"
	for h in $(find "$(dirname "$0")"/keymaps/"$g" -maxdepth 1 -mindepth 1 -type f -name "*.hex" -exec basename "{}" .hex ";"); do
		keymap="$(echo $h | sed -nE 's/(.*)-(.*)/\2/p')"
		ln -v "$(dirname "$0")"/flash-util/flash-script.sh "$(dirname "$0")"/flash-scripts/"$model"/flash-"$g"-"$keymap".sh
	done
done
