@echo off

set vialver=0p4p1
set nathanaver=r5

for /f "tokens=2,3 delims=-" %%a in ("%~n0") do (
	set model=%%a
	set keymap=%%b
)

if "%model%" == "" exit /b 1
if "%keymap%" == "" exit /b 1

echo Preparing to flash firmware for "%model%" with keymap "%keymap%"...
"%~dp0\..\..\flash-util\dfu-programmer" atmega32u2 get bootloader-version > NUL 2>&1
if not errorlevel 1 goto flash
echo.
echo Please plug in keyboard to be flashed, and put into bootloader/flash mode.
echo Waiting for keyboard...
:waitforusb1
"%~dp0\..\..\flash-util\dfu-programmer" atmega32u2 get bootloader-version > NUL 2>&1
if errorlevel 1 goto waitforusb1
:flash
echo.
echo * Wiping existing flash memory and EEPROM...
"%~dp0\..\..\flash-util\dfu-programmer.exe" atmega32u2 erase --force > NUL 2>&1
"%~dp0\..\..\flash-util\dfu-programmer.exe" atmega32u2 flash --force --suppress-validation --eeprom "%~dp0\..\..\flash-util\reset.eep" > NUL 2>&1
"%~dp0\..\..\flash-util\dfu-programmer.exe" atmega32u2 flash --force "%~dp0\..\..\flash-util\eeprom_eraser.hex" > NUL 2>&1
echo * Resetting controller for main flash...
"%~dp0\..\..\flash-util\dfu-programmer.exe" atmega32u2 reset > NUL 2>&1
:waitforusb2
"%~dp0\..\..\flash-util\dfu-programmer" atmega32u2 get bootloader-version > NUL 2>&1
if errorlevel 1 goto waitforusb2
echo * Flashing "%model%" firmware...
"%~dp0\..\..\flash-util\dfu-programmer.exe" atmega32u2 erase --force > NUL 2>&1
"%~dp0\..\..\flash-util\dfu-programmer.exe" atmega32u2 flash --force "%~dp0\..\..\firmwares\new%model%-vial-%vialver%_%nathanaver%.hex" > NUL 2>&1
echo * Flashing "%keymap%" keymap...
"%~dp0\..\..\flash-util\dfu-programmer.exe" atmega32u2 flash --force --eeprom "%~dp0\..\..\keymaps\%model%\%model%-%keymap%.hex" > NUL 2>&1
echo * Rebooting keyboard controller...
"%~dp0\..\..\flash-util\dfu-programmer.exe" atmega32u2 reset > NUL 2>&1
echo.
echo ...done!
echo.
pause
