#!/bin/sh

vialver=0p4p1
nathanaver=r5

model=$(echo "$(basename "$0")" | sed -nE 's/flash-(.*)-(.*)\..*/\1/p')
keymap=$(echo "$(basename "$0")" | sed -nE 's/flash-(.*)-(.*)\..*/\2/p')

if [ "$model" = "" ]; then exit 1; fi
if [ "$keymap" = "" ]; then exit 1; fi

echo
echo Preparing to flash firmware for \""$model"\" with keymap \""$keymap"\"...
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 get bootloader-version > /dev/null 2>&1
if [ $? -gt 0 ]; then
echo
echo Please plug in keyboard to be flashed, and put into bootloader/flash mode.
echo Waiting for keyboard...
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 get bootloader-version > /dev/null 2>&1
while [ $? -gt 0 ]; do
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 get bootloader-version > /dev/null 2>&1
done
fi
echo
echo \* Wiping existing flash memory and EEPROM...
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 erase --force > /dev/null 2>&1
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 flash --force --suppress-validation --eeprom "$(dirname "$0")"/../../flash-util/reset.eep > /dev/null 2>&1
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 flash --force "$(dirname "$0")"/../../flash-util/eeprom_eraser.hex > /dev/null 2>&1
echo \* Resetting controller for main flash...
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 reset > /dev/null 2>&1
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 get bootloader-version > /dev/null 2>&1
while [ $? -gt 0 ]; do
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 get bootloader-version > /dev/null 2>&1
done
echo \* Flashing \""$model"\" firmware...
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 erase --force > /dev/null 2>&1
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 flash --force "$(dirname "$0")"/../../firmwares/new"$model"-vial-"$vialver"_"$nathanaver".hex > /dev/null 2>&1
echo \* Flashing \""$keymap"\" keymap...
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 flash --force --eeprom "$(dirname "$0")"/../../keymaps/"$model"/"$model"-"$keymap".hex > /dev/null 2>&1
echo \* Rebooting keyboard controller...
"$(dirname "$0")"/../../flash-util/dfu-programmer atmega32u2 reset > /dev/null 2>&1
echo
echo ...done!
echo
read -p "Press any key to continue . . . "
echo
